/* Antarmuka dengan Sensor Cahaya Analog - Basic IoT Kit ESP32
 * Project : IoT Light Meter dengan Sensor Cahaya Analog
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP32 WiFi dan Firebase ESP32
#include <WiFi.h>
#include <FirebaseESP32.h>

// Library OLED Display
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

// Mengatur OLED Display dengan resolusi 128x64
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET    -1
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"


// PIN Sensor Cahaya LDR dan PD terhubung ke PIN 34 dan 35
#define LDR_PIN  34
#define PD_PIN   35

// Firebase objek dengan nama fbdo
FirebaseData fbdo;

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

// Variabel untuk menyimpan data ADC dan data konversi sensor  
int ldr_adc, ldr_value;
int pd_adc, pd_value;

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);

  // Memulai komunikasi dengan OLED Display
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);

  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);

  // Membersihkan tampilan display
  display.clearDisplay();
}

void loop() { 
  // Membaca data ADC sensor
  // ADC disimpan pada 'ldr_adc' dan 'pd_adc'
  // Data konversi ke persen disimpan pada 'ldr_value' dan 'pd_value'
  ldr_adc   = analogRead(LDR_PIN);
  ldr_value = map(ldr_adc, 0, 4096, 0, 100);

  pd_adc   = analogRead(PD_PIN);
  pd_value = map(pd_adc, 0, 4096, 0, 100);

  // Mencetak data pada serial monitor
  Serial.println("LDR : " + String(ldr_value) + " %");
  Serial.println("PD  : " + String(ldr_value) + " %");
  Serial.println();

  // Mengirim data sensor ke database
  // dengan alamat */user/gauge1 dan */user/gauge1
  Firebase.setInt(fbdo, "/" + user + "/gauge1", ldr_value);
  Firebase.setInt(fbdo, "/" + user + "/gauge2", pd_value);
  
  // display LDR
  display.setTextSize(1);         // Mengatur ukuran teks = 1
  display.setTextColor(WHITE);    // Mengatur teks warna putih
  display.setCursor(0,0);         // Mengatur kursor (x:0, y:0)
  display.print("LDR Data:");     // Mencetak Teks "LDR Data:"
  display.setTextSize(2);         // Mengatur ukuran teks = 2
  display.setCursor(0,10);        // Mengatur kursor (x:0, y:10)
  display.print(ldr_value);       // Mencetak Nilai Sensor LDR
  display.setCursor(45, 10);      // Mengatur kursor (x:45, y:10)
  display.print("%");             // Mencetak Teks persen

  // display PD
  display.setTextSize(1);         // Mengatur ukuran teks = 1
  display.setTextColor(WHITE);    // Mengatur teks warna putih
  display.setCursor(0, 35);       // Mengatur kursor (x:0, y:35)
  display.print("PD  Data:");     // Mencetak Teks "PD Data:"
  display.setTextSize(2);         // Mengatur ukuran teks = 2
  display.setCursor(0, 45);       // Mengatur kursor (x:0, y:45)
  display.print(pd_value);         // Mencetak Nilai Sensor PD
  display.setCursor(45, 45);      // Mengatur kursor (x:45, y:45)
  display.print("%");             // Mencetak Teks persen

  display.display();              // Menampilkan data
  display.clearDisplay();         // Membersihkan tampilan display
}
